<?php

namespace AdminBundle\Controller;

use AdminBundle\Entity\Category;
use AdminBundle\Form\Handler\CategoryFormHandler;
use AdminBundle\Form\Type\CategoryFormType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class CategoryController extends Controller {

    /**
     * @Route("/categories", name="admin_categories")
     * @Method("GET")
     * @Template()
     */
    public function indexAction() {
        $repository = $this->get('category_repository');
        return array('categories' => $repository->findAll());
    }

    /**
     * @Route("/category", name="admin_category_create")
     * @Method({"GET","POST"})
     * @Template()
     */
    public function createAction(Request $request) {
        $form = $this->createForm(new CategoryFormType(), new Category());
        $form->handleRequest($request);

        $handler = new CategoryFormHandler($form, $request, $this->container);
        if($form->isValid() && $handler->process()) {
            return $this->redirect($this->generateUrl('admin_categories'));
        }
        return array('form' => $form->createView());
    }

    /**
     * @Route("/category/{id}", name="admin_category_edit")
     * @ParamConverter(name="category", class="AdminBundle\Entity\Category")
     * @Method({"GET","POST"})
     * @Template()
     */
    public function editAction(Request $request, Category $category) {
        $form = $this->createForm(new CategoryFormType(), $category);
        $form->handleRequest($request);

        $handler = new CategoryFormHandler($form, $request, $this->container);
        if($form->isValid() && $handler->process()) {
            return $this->redirect($this->generateUrl('admin_categories'));
        }
        return array('form' => $form->createView());
    }

    /**
     * @Route("/category/delete/{id}", name="admin_category_delete")
     * @ParamConverter(name="category", class="AdminBundle\Entity\Category")
     * @Method("GET")
     */
    public function deleteCategoryAction(Category $category) {
        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->remove($category);
        $entityManager->flush();

        return $this->redirect($this->generateUrl('admin_categories'));
    }

    /**
     * @Route("/categories/ordering", name="admin_category_ordering")
     * @Method("POST")
     */
    public function orderCategoriesAction(Request $request) {
        $ordering = $request->request->get('categories');

        $repository = $this->get('category_repository');
        foreach($repository->findAll() as $category) {
            $category->setPosition($ordering[$category->getId()]);
        }
        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->flush();

        return new JsonResponse(array());
    }

}