<?php

namespace AdminBundle\Controller;

use AdminBundle\Form\Handler\PictureFormHandler;
use AdminBundle\Form\PictureForm;
use AdminBundle\Form\Type\PictureFormType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class GalleryController extends Controller {

    /**
     * @Route("/gallery", name="admin_gallery")
     * @Method("GET")
     * @Template()
     */
    public function indexAction() {
        $repository = $this->get('gallery_repository');
        return array('pictures' => $repository->findAll());
    }

    /**
     * @Route("/gallery/picture", name="admin_gallery_picture")
     * @Method({"GET","POST"})
     * @Template("AdminBundle:Gallery:form.html.twig")
     */
    public function pictureAction(Request $request) {
        $pictureForm = new PictureForm();
        $form = $this->createForm(new PictureFormType(), $pictureForm);
        $form->handleRequest($request);
        $handler = new PictureFormHandler($form, $request, $this->container);

        if($form->isValid() && $handler->process()) {
            return $this->redirect($this->generateUrl('admin_gallery'));
        }
        return array('form' => $form->createView());
    }

}